<?php
if (!defined('FUNC_FILE')) die("Illegal File Access");

// PHP Version
$phpver = phpversion();
if ($phpver < '4.1.0') {
	$_GET = $HTTP_GET_VARS;
	$_POST = $HTTP_POST_VARS;
	$_COOKIE = $HTTP_COOKIE_VARS;
	$_REQUEST = array_merge($_GET, $_POST, $_COOKIE);
	$_FILES = $HTTP_POST_FILES;
	$_SERVER = $HTTP_SERVER_VARS;
}
$phpver = explode(".", $phpver);
$phpver = "$phpver[0]$phpver[1]";
if ($phpver >= 41) {
	$PHP_SELF = $_SERVER['PHP_SELF'];
}

// Security config require
require_once("config/config_security.php");
require_once("config/config_blocker.php");

// Error reporting
if ($error_reporting == 1) {
	error_reporting (E_ALL ^ E_NOTICE);
} else {
	error_reporting (0);
}

// GZip
if ($phpver >= '4.0.4pl1' && (strstr($_SERVER['HTTP_USER_AGENT'], 'compatible') || strstr($_SERVER['HTTP_USER_AGENT'], 'Gecko'))) {
	if (extension_loaded('zlib')) ob_start('ob_gzhandler');
} else if ($phpver > '4.0') {
	if (strstr($HTTP_SERVER_VARS['HTTP_ACCEPT_ENCODING'], 'gzip')) {
		if (extension_loaded('zlib')) {
			$do_gzip_compress = true;
			ob_start();
			ob_implicit_flush(0);
			Header('Content-Encoding: gzip');
		}
	}
}

// Security magic quotes gpc
if (!get_magic_quotes_gpc()) {
	reset($_GET);
	foreach ($_GET as $key => $value) {
		global $$key;
		$$key = addslashes($value);
	}
	reset($_POST);
	foreach ($_POST as $key => $value) {
		global $$key;
		$$key = addslashes($value);
	}
	reset($_COOKIE);
	foreach ($_COOKIE as $key => $value) {
		global $$key;
		$$key = addslashes($value);
	}
	reset($_REQUEST);
	foreach ($_REQUEST as $key => $value) {
		global $$key;
		$$key = addslashes($value);
	}
}

// Output buffering on
ob_start();

// Security test blocker
if (isset($_COOKIE[SECURITY_COOKIE]) == "block") security_blocker($security_blocker_msg);
if ($security_blocker_ip != "") {
	$temp_ip = getenv("REMOTE_ADDR");
	$security_blocker_ip = explode(",", $security_blocker_ip);
	foreach ($security_blocker_ip as $key => $val) {
		$temp_ip_block = $temp_ip;
		$blocker_ip = $val;
		if ($security_blocker_mask <= 3) {
			$temp_ip_block = substr($temp_ip_block, 0, strrpos($temp_ip_block, '.'));
			$blocker_ip = substr($blocker_ip, 0, strrpos($blocker_ip, '.'));
		}
		if ($security_blocker_mask <= 2) {
			$temp_ip_block = substr($temp_ip_block, 0, strrpos($temp_ip_block, '.'));
			$blocker_ip = substr($blocker_ip, 0, strrpos($blocker_ip, '.'));
		}
		if ($security_blocker_mask == 1) {
			$temp_ip_block = substr($temp_ip_block, 0, strrpos($temp_ip_block, '.'));
			$blocker_ip = substr($blocker_ip, 0, strrpos($blocker_ip, '.'));
		}
		if ($temp_ip_block == $blocker_ip) security_blocker($security_blocker_msg);
	}
}
if ($security_blocker_user != "") {
	$temp_user = $_COOKIE[USER_COOKIE];
	$temp_user = explode(":", addslashes(base64_decode($temp_user)));
	$temp_user = substr("".$temp_user[1]."", 0, 25);
	$security_blocker_user = explode(",", $security_blocker_user);
	foreach ($security_blocker_user as $key => $val) {
		if ($val == $temp_user && $val != "") security_blocker($security_blocker_msg);
	}
}

// Security blocker
function security_blocker($security_blocker_msg) {
	setcookie(SECURITY_COOKIE, "block", time() + 86400);
	die("<br /><br /><center><img src=\"images/logo.gif\" alt=\"".$security_blocker_msg."\" /><br /><br /><b>".$security_blocker_msg."</b></center>");
}

// Error reporting log
if ($error_reporting_log == 1) {
	if (isset($_GET['error'])) {
		$error = intval($_GET['error']);
		$error_log = false;
		if ($error == "400") $error_log = "400 Bad Request";
		if ($error == "401") $error_log = "401 Authorization Required";
		if ($error == "403") $error_log = "403 Forbidden";
		if ($error == "404") $error_log = "404 Not Found";
		if ($error == "500") $error_log = "500 Internal Server Error";
		if ($error == "503") $error_log = "503 Service Unavailable";
		if ($error_log) {
			require_once("language/lang-".$language.".php");
			$url = htmlspecialchars(trim(getenv("REQUEST_URI")), ENT_QUOTES);
			$date_time = date("d.m.y - H:i:s");
			$log_header = (!file_exists("config/logs/error_logs_site.php")) ? "<?php if (!defined(\"ADMIN_FILE\")) die(\"Illegal File Access\"); ?>\n---\n" : "";
			if ($fhandle = @fopen("config/logs/error_logs_site.php", "a")) {
				fwrite($fhandle, "".$log_header."".$error_log."\n"._URL.": ".$url."\n"._STARTDATE.": ".$date_time."\n---\n");
				fclose($fhandle);
			}
		}
	}
	function error_reporting_log($error_num, $error_var, $error_file, $error_line) {
		$error_write = false;
		switch ($error_num) {
			case 1:
			$error_desc = "ERROR";
			$error_write = true;
			break;
			case 2:
			$error_desc = "WARNING";
			$error_write = true;
			break;
			case 4:
			$error_desc = "PARSE";
			$error_write = true;
			break;
			case 8:
			$error_desc = "NOTICE";
			$error_write = false;
			break;
		}
		if ($error_write) {
			global $language;
			require_once("language/lang-".$language.".php");
			$url = htmlspecialchars(trim(getenv("REQUEST_URI")), ENT_QUOTES);
			$date_time = date("d.m.y - H:i:s");
			$log_header = (!file_exists("config/logs/error_logs.php")) ? "<?php if (!defined(\"ADMIN_FILE\")) die(\"Illegal File Access\"); ?>\n---\n" : "";
			if ($fhandle = @fopen("config/logs/error_logs.php", "a")) {
				fwrite($fhandle, "".$log_header."".$error_desc.": ".$error_var." Line: ".$error_line." in file ".$error_file."\n"._URL.": ".$url."\n"._STARTDATE.": ".$date_time."\n---\n");
				fclose($fhandle);
			}
		}
	}
	set_error_handler('error_reporting_log');
}

// Security GET, POST, COOKIE, FILES
if (!defined('ADMIN_FILE')) {
	foreach ($_GET as $var_name=>$var_value) {
		if (preg_match("/<.*?(script|body|object|iframe|applet|meta|style|form|img|onmouseover).*?>/i", urldecode($var_value)) || preg_match("/\([^>]*\"?[^)]*\)/", $var_value) || preg_match("/\"|\'/", $var_value)) warn_report("HTML in GET - ".$var_name." = ". $var_value."");
		if ($security_url_get == 1) {
			if (preg_match("/^(http\:\/\/|ftp\:\/\/|\/\/|https:\/\/|php:\/\/|\/\/)/i", $var_value)) warn_report("URL in GET - ".$var_name." = ". $var_value);
		}
		$security_string = "/UNION|OUTFILE|SELECT|ALTER|INSERT|DROP|".$prefix."_admins|".$prefix."_users|ModAdmin|SaveAdmin|EditAdmin|DelAdmin/i";
		$security_decode = base64_decode($var_value);
		if (preg_match($security_string, $security_decode)) hack_report("Hack base64 in GET - ".$var_name." = ". $var_value."");
		if (preg_match($security_string, $var_value)) hack_report("Hack in GET - ".$var_name." = ". $var_value."");
		$security_slash = preg_replace("/\/\*.*?\*\//", "", $var_value);
		if (preg_match($security_string, $security_slash)) hack_report("Hack in GET - ".$var_name." = ". $var_value."");
	}
	foreach ($_POST as $var_name=>$var_value) {
		if (preg_match("/<.*?(script|body|object|iframe|applet|meta|style|form|onmouseover).*?>/i", urldecode($var_value))) warn_report("HTML in POST - ".$var_name." = ". $var_value."");
		if ($security_url_post == 1) {
			if (preg_match("/^(http\:\/\/|ftp\:\/\/|\/\/|https:\/\/|php:\/\/|\/\/)/i", $var_value)) warn_report("URL in POST - ".$var_name." = ". $var_value);
		}
		$security_string = "/UNION|OUTFILE|SELECT|ALTER|INSERT|DROP|".$prefix."_admins|".$prefix."_users|ModAdmin|SaveAdmin|EditAdmin|DelAdmin/i";
		$security_decode = base64_decode($var_value);
		if (preg_match($security_string, $security_decode)) hack_report("Hack base64 in POST - ".$var_name." = ". $var_value."");
		if (preg_match($security_string, $var_value)) hack_report("Hack in POST - ".$var_name." = ". $var_value."");
		$security_slash = preg_replace("/\/\*.*?\*\//", "", $var_value);
		if (preg_match($security_string, $security_slash)) hack_report("Hack in POST - ".$var_name." = ". $var_value."");
	}
}

foreach ($_COOKIE as $var_name=>$var_value) {
	if (preg_match("/<.*?(script|body|object|iframe|applet|meta|style|form|img|onmouseover).*?>/i", $var_value)) hack_report("Hack in COOKIE - ".$var_name." = ". $var_value."");
	if (preg_match("/^(http\:\/\/|ftp\:\/\/|\/\/|https:\/\/|php:\/\/|\/\/)/i", $var_value)) hack_report("Hack in COOKIE - ".$var_name." = ". $var_value);
	$security_string = "/UNION|OUTFILE|SELECT|ALTER|INSERT|DROP|FROM|WHERE|UPDATE|".$prefix."_admins|".$prefix."_users|ModAdmin|SaveAdmin|EditAdmin|DelAdmin/i";
	$security_decode = base64_decode($var_value);
	if (preg_match($security_string, $security_decode)) hack_report("Hack base64 in COOKIE - ".$var_name." = ". $var_value."");
	if (preg_match($security_string, $var_value)) hack_report("Hack in COOKIE - ".$var_name." = ". $var_value."");
	$security_slash = preg_replace("/\/\*.*?\*\//", "", $var_value);
	if (preg_match($security_string, $security_slash)) hack_report("Hack in COOKIE - ".$var_name." = ". $var_value."");
}

foreach ($_FILES as $var_name=>$var_value) {
	$var_value = end(explode(".", $_FILES['userfile']['name']));
	if (preg_match("/php|php3|php4|php5|php6|js|htm|html|phtml|cgi|pl|perl|asp/i", $var_value)) hack_report("Hack in FILES - ".$var_name." = ". $var_value."");
}

reset($_GET);
reset($_POST);
reset($_COOKIE);
reset($_FILES);

function hack_report($msg) {
	global $language, $adminmail, $anonymous, $sitename, $security_mail, $security_write, $security_block;
	require_once("language/lang-".$language.".php");
	$msg = htmlspecialchars(trim(substr($msg, 0, 500)), ENT_QUOTES);
	$url = htmlspecialchars(trim(getenv("REQUEST_URI")), ENT_QUOTES);
	$ip = getenv("REMOTE_ADDR");
	$agent = getenv("HTTP_USER_AGENT");
	$date_time = date("d.m.y - H:i:s");
	if (isset($_COOKIE[USER_COOKIE])) {
		$user = $_COOKIE[USER_COOKIE];
		$user = explode(":", addslashes(base64_decode($user)));
		$user = substr("".$user[1]."", 0, 25);
		$user_block = "".$user.",";
	} else {
		$user = substr($anonymous, 0, 25);
	}
	if ($security_block == 1) {
		$ip_block = "".$ip.",";
		include("config/config_blocker.php");
		$fp = @fopen("config/config_blocker.php", "w");
		$cont = "\$security_blocker_ip = \"".$ip_block."".$security_blocker_ip."\";\n";
		$cont .= "\$security_blocker_user = \"".$user_block."".$security_blocker_user."\";\n";
		$content = "<?php\nif (!defined(\"FUNC_FILE\")) die(\"Illegal File Access\");\n\n".$cont."\n?>";
		fwrite($fp, $content);
		fclose($fp);
		setcookie(SECURITY_COOKIE, "block", time() + 86400);
	}
	if ($security_mail == 1) {
		$subject = "$sitename - "._SECURITY."";
        $msg_mail = "$sitename - "._SECURITY."\n\n";
		$msg_mail .= ""._HACK.": ".$msg."\n"._IP.": ".$ip."\n"._USER.": ".$user."\n"._URL.": ".$url."\n"._BROWSER.": ".$agent."\n"._STARTDATE.": ".$date_time."\n";
		$mailheaders = "Content-Type: text/plain; charset="._CHARSET."\n";
		$mailheaders .= "X-Priority: 1\n";
		$mailheaders .= "From: \""._SECURITY."\" <$adminmail>";
		mail($adminmail, $subject, $msg_mail, $mailheaders);
	}
	if ($security_write == 1) {
		$log_header = (!file_exists("config/logs/warn_logs.php")) ? "<?php if (!defined(\"ADMIN_FILE\")) die(\"Illegal File Access\"); ?>\n---\n" : "";
		if ($fhandle = @fopen("config/logs/warn_logs.php", "a")) {
			fwrite($fhandle, "".$log_header.""._HACK.": ".$msg."\n"._IP.": ".$ip."\n"._USER.": ".$user."\n"._URL.": ".$url."\n"._BROWSER.": ".$agent."\n"._STARTDATE.": ".$date_time."\n---\n");
			fclose($fhandle);
		}
	}
	setcookie(USER_COOKIE, false);
	Header("Location: index.php");
	exit;
}

function warn_report($msg) {
	global $language, $adminmail, $anonymous, $sitename, $security_mail, $security_write;
	require_once("language/lang-".$language.".php");
	$msg = htmlspecialchars(trim(substr($msg, 0, 500)), ENT_QUOTES);
	$url = htmlspecialchars(trim(getenv("REQUEST_URI")), ENT_QUOTES);
	$ip = getenv("REMOTE_ADDR");
	$agent = getenv("HTTP_USER_AGENT");
	$date_time = date("d.m.y - H:i:s");
	if (isset($_COOKIE[USER_COOKIE])) {
		$user = $_COOKIE[USER_COOKIE];
		$user = explode(":", addslashes(base64_decode($user)));
	    $user = substr("".$user[1]."", 0, 25);
	} else {
		$user = substr($anonymous, 0, 25);
	}
	if ($security_mail == 1) {
		$subject = "$sitename - "._SECURITY."";
        $msg_mail = "$sitename - "._SECURITY."\n\n";
		$msg_mail .= ""._WARN.": ".$msg."\n"._IP.": ".$ip."\n"._USER.": ".$user."\n"._URL.": ".$url."\n"._BROWSER.": ".$agent."\n"._STARTDATE.": ".$date_time."\n";
		$mailheaders = "Content-Type: text/plain; charset="._CHARSET."\n";
		$mailheaders .= "X-Priority: 1\n";
		$mailheaders .= "From: \""._SECURITY."\" <$adminmail>";
		mail($adminmail, $subject, $msg_mail, $mailheaders);
	}
	if ($security_write == 1) {
		$log_header = (!file_exists("config/logs/warn_logs.php")) ? "<?php if (!defined(\"ADMIN_FILE\")) die(\"Illegal File Access\"); ?>\n---\n" : "";
		if ($fhandle = @fopen("config/logs/warn_logs.php", "a")) {
			fwrite($fhandle, "".$log_header.""._WARN.": ".$msg."\n"._IP.": ".$ip."\n"._USER.": ".$user."\n"._URL.": ".$url."\n"._BROWSER.": ".$agent."\n"._STARTDATE.": ".$date_time."\n---\n");
			fclose($fhandle);
		}
	}
	Header("Location: index.php");
	exit;
}

unset($name, $file, $admin, $user, $admintrue, $usertrue, $aid, $uname, $guest);
if (isset($_COOKIE[ADMIN_COOKIE])) $admin = explode(":", addslashes(base64_decode($_COOKIE[ADMIN_COOKIE])));
if (isset($_COOKIE[USER_COOKIE])) $user = explode(":", addslashes(base64_decode($_COOKIE[USER_COOKIE])));
?>